﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelOutbound
{
    /// <summary>
    /// Get Integration Settings step.
    /// </summary>
    public class GetIntegrationSettingsStep : FilterBase<MakeCancelOutboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelOutboundStateObject state)
        {
            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                var useFakeResponse = srv.mcs_integrationsettingSet.First(x => x.mcs_name == "HealthShare MakeCancel Outbound Use Fake").mcs_value;
                state.UseFakeResponse = Convert.ToBoolean(useFakeResponse);
            }
        }
    }
}